/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.moulberry.axiom.commands.SpannedStyle;
import com.moulberry.axiom.commands.SyntaxStyles;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public interface BlockArgument {
    public static final DynamicCommandExceptionType INVALID_PERCENTAGE = new DynamicCommandExceptionType(found -> new LiteralMessage("Percentage must be positive, found " + String.valueOf(found)));
    public static final SimpleCommandExceptionType EXPECTED_BLOCK = new SimpleCommandExceptionType((Message)new LiteralMessage("Expected block"));

    public class_2680 get(float var1);

    public static BlockArgument parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw new IllegalStateException("StringReader with no input");
        }
        TreeMap<Float, class_2680> map = new TreeMap<Float, class_2680>();
        float total = 0.0f;
        while (reader.canRead()) {
            if (total > 0.0f) {
                reader.expect(',');
                if (!reader.canRead()) break;
            }
            float amount = 1.0f;
            char peek = reader.peek();
            int beforeFloat = reader.getCursor();
            if ('0' <= peek && peek <= '9') {
                amount = reader.readFloat() / 100.0f;
                reader.expect('%');
            }
            if (amount <= 0.0f) {
                reader.setCursor(beforeFloat);
                throw INVALID_PERCENTAGE.createWithContext((ImmutableStringReader)reader, (Object)Float.valueOf(amount));
            }
            class_2248 block = BlockArgument.readBlock(reader);
            map.put(Float.valueOf(total), block.method_9564());
            total += amount;
        }
        if (map.isEmpty()) {
            throw new FaultyImplementationError("Empty map");
        }
        if (total <= 0.0f) {
            throw new FaultyImplementationError("Non-positive total");
        }
        if (map.size() == 1) {
            return new Single((class_2680)map.values().iterator().next());
        }
        TreeMap<Float, class_2680> normalized = new TreeMap<Float, class_2680>();
        for (Map.Entry entry : map.entrySet()) {
            normalized.put(Float.valueOf(((Float)entry.getKey()).floatValue() / total), (class_2680)entry.getValue());
        }
        return new Multi(normalized);
    }

    private static class_2248 readBlock(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw EXPECTED_BLOCK.createWithContext((ImmutableStringReader)reader);
        }
        int beforeId = reader.getCursor();
        class_2960 id = class_2960.method_12835((StringReader)reader);
        return (class_2248)((class_6880.class_6883)class_7923.field_41175.method_40264(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)id)).orElseThrow(() -> {
            reader.setCursor(beforeId);
            return class_2259.field_10690.createWithContext((ImmutableStringReader)reader, (Object)id.toString());
        })).comp_349();
    }

    public static void highlight(List<SpannedStyle> styles, StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw new IllegalStateException("StringReader with no input");
        }
        int from = reader.getCursor();
        boolean first = true;
        while (reader.canRead()) {
            if (first) {
                first = false;
            } else {
                reader.expect(',');
                styles.add(new SpannedStyle(SyntaxStyles.GRAY, from, reader.getCursor()));
                from = reader.getCursor();
                if (!reader.canRead()) break;
            }
            float amount = 1.0f;
            char peek = reader.peek();
            int beforeFloat = reader.getCursor();
            if ('0' <= peek && peek <= '9') {
                amount = reader.readFloat() / 100.0f;
                styles.add(new SpannedStyle(SyntaxStyles.NUMBER_ARGUMENT, from, reader.getCursor()));
                from = reader.getCursor();
                reader.expect('%');
                styles.add(new SpannedStyle(SyntaxStyles.GRAY, from, reader.getCursor()));
                from = reader.getCursor();
            }
            if (amount <= 0.0f) {
                reader.setCursor(beforeFloat);
                throw INVALID_PERCENTAGE.createWithContext((ImmutableStringReader)reader, (Object)Float.valueOf(amount));
            }
            BlockArgument.readBlock(reader);
            styles.add(new SpannedStyle(SyntaxStyles.BLOCK_ARGUMENT, from, reader.getCursor()));
            from = reader.getCursor();
        }
    }

    public record Single(class_2680 state) implements BlockArgument
    {
        @Override
        public class_2680 get(float f) {
            return this.state;
        }
    }

    public record Multi(TreeMap<Float, class_2680> map) implements BlockArgument
    {
        @Override
        public class_2680 get(float f) {
            if (f < 0.0f) {
                f = ThreadLocalRandom.current().nextFloat();
            }
            return this.map.floorEntry(Float.valueOf(f)).getValue();
        }
    }
}

